import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Spin as Spinner } from 'antd';
import { LoadingOutlined } from '@ant-design/icons';
import './Spin.less';

export const Spin = ({ size, className }) => (
    <div className={classNames('spinner', className)}>
        <Spinner indicator={<LoadingOutlined style={{ fontSize: size }} />} />
    </div>
);

Spin.propTypes = {
    size: PropTypes.number,
    className: PropTypes.string,
};

Spin.defaultProps = {
    size: 24,
};
