import { connect } from 'react-redux';
import { TaskPageLayoutView } from './TaskPageLayout';
import { getVideoLinksUsecase } from '../../usecases/getVideoLinksUsecase';
import { setVideoError, setVideoPlayed } from '../../domain/store/actions/ui';

const mapStateToProps = (state) => {
    const { activeDocumentIndex } = state.ui;
    const { document_types: availableDocumentTypes, secret, user_id: userId, task_type: taskType } = state.input;

    return {
        userId,
        taskType,
        activeDocumentIndex,
        availableDocumentTypes,
        videoUrls: getVideoLinksUsecase({ secret, availableDocumentTypes }),
    };
};

const mapDispatchToProps = (dispatch) => ({
    setVideoError: (params) => dispatch(setVideoError(params)),
    setVideoPlayed: (params) => dispatch(setVideoPlayed(params)),
});

export const TaskPageLayout = connect(mapStateToProps, mapDispatchToProps)(TaskPageLayoutView);
