/* eslint-disable camelcase */
import { createStore, compose } from 'redux';
import taskReducer from './reducers';
import { loadInputValues } from './actions/input';
import { setFacts } from './actions/documents';
import { resetMiddleware } from './middleware';
import { initSolution } from './actions/solution';
import { DOCUMENT_TYPES } from '../documents';
import { initInternalState, setScaleOptions } from './actions/ui';

const documentsFactory = (availableTypes, initialValue = []) =>
    availableTypes.reduce((verdicts, type) => ({ ...verdicts, [type]: initialValue }), {});

export const store = compose(resetMiddleware())(createStore)(taskReducer);
export const dispatch = store.dispatch;

export const initStore = (input, facts, scaleOptions) => {
    const availableDocumentTypes = Array.isArray(input.document_types)
        ? input.document_types.filter((document) => DOCUMENT_TYPES.includes(document))
        : DOCUMENT_TYPES;

    const internalState = availableDocumentTypes.reduce(
        (documents, document) => ({ ...documents, [document]: false }),
        {},
    );

    dispatch(loadInputValues({ ...input, document_types: availableDocumentTypes }));

    dispatch(setFacts(facts));

    dispatch(setScaleOptions(scaleOptions));

    dispatch(
        initInternalState({
            formErrors: internalState,
            videoPlayed: internalState,
        }),
    );

    dispatch(
        initSolution({
            verdicts: documentsFactory(availableDocumentTypes),
            comments: documentsFactory(availableDocumentTypes, ''),
        }),
    );
};

export const resetStore = () => dispatch({ type: 'RESET' });
