import { getType } from 'typesafe-actions';
import { pageUpdateConverter, pageDeleteConverter } from './pageConverter';
import * as actions from '../../actions/documents';

export class TemplateBackendActionsCollector {
    backendActions = [];

    setAction(action, state) {
        const converter = this.resolveConverter(action.type);

        if (!converter) {
            return;
        }

        // eslint-disable-next-line no-unused-vars
        const { meta, ...actionWithoutMeta } = action;

        this.backendActions = converter(this.backendActions, actionWithoutMeta, state);
    }

    getBackendActions() {
        return this.backendActions.map((action) => {
            // eslint-disable-next-line no-unused-vars
            const { meta, ...rest } = action;

            return rest;
        });
    }

    resetActions() {
        this.backendActions = [];
    }

    resolveConverter(type) {
        switch (type) {
            case getType(actions.setPage):
                return pageUpdateConverter;
            case getType(actions.deletePage):
                return pageDeleteConverter;
        }

        return null;
    }
}

let collector;

export const getBackendActionsCollector = () => {
    if (!collector) {
        collector = new TemplateBackendActionsCollector();
    }

    return collector;
};
