export const pageUpdateConverter = (backendActions, action) => {
    const { path, title, body, isNew, isUpdated, isTrimmed } = action.payload;

    if (!isNew && !isUpdated) {
        return backendActions; // we don't care about the initial page loading
    }
    const actions = backendActions.filter((a) => a.data.path !== path);

    return actions.concat({
        type: isNew ? 'PAGE_CREATE' : 'PAGE_UPDATE',
        timestamp: Date.now(),
        data: {
            path,
            title,
            body,
            isTrimmed,
        },
    });
};

export const pageDeleteConverter = (backendActions, action, state) => {
    const { path } = action.payload;
    const target = state.common.pages[path] || {};

    const actions = backendActions.filter((a) => a.data.path !== path);

    if (target.isNew) {
        return actions; // we don't care about newly created pages
    }

    return actions.concat({
        type: 'PAGE_DELETE',
        timestamp: Date.now(),
        data: {
            path,
        },
    });
};
