import { getType } from 'typesafe-actions';
import * as actions from '../actions/solution';

const initialState = {
    verdicts: {},
    comments: {},
};

const solutionReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.initSolution):
            return {
                ...state,
                ...action.payload,
            };

        case getType(actions.setSolution):
            return {
                ...state,
                verdicts: {
                    ...state.verdicts,
                    ...(action.payload.verdicts || {}),
                },
                comments: {
                    ...state.comments,
                    ...(action.payload.comments || {}),
                },
            };

        default:
            return state;
    }
};

export default solutionReducer;
