/* eslint-disable camelcase */
import { getType } from 'typesafe-actions';
import * as actions from '../actions/ui';

const initialState = {
    formErrors: {},
    videoPlayed: {},
    videoError: {},
    signals: {
        validation: null,
    },
    scaleOptions: {
        multipleSelect: false,
        otherWithComment: false,
    },
    taskError: null,
    activeDocumentIndex: 0,
};

const uiReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.initInternalState):
            return {
                ...state,
                formErrors: { ...action.payload.formErrors },
                videoPlayed: { ...action.payload.videoPlayed },
            };

        case getType(actions.setScaleOptions):
            return {
                ...state,
                scaleOptions: { ...action.payload },
            };

        case getType(actions.setFormError):
            return {
                ...state,
                formErrors: {
                    ...state.formErrors,
                    [action.payload.document]: action.payload.errorFlag,
                },
            };

        case getType(actions.sendValidationSignal):
            return {
                ...state,
                signals: {
                    ...state.signals,
                    validation: Date.now(),
                },
            };

        case getType(actions.setTaskError):
            return {
                ...state,
                taskError: action.payload,
            };

        case getType(actions.setActiveDocumentIdx):
            return {
                ...state,
                activeDocumentIndex: action.payload,
            };

        case getType(actions.setVideoPlayed):
            return {
                ...state,
                videoPlayed: {
                    ...state.videoPlayed,
                    [action.payload.document]: action.payload.value,
                },
            };

        case getType(actions.setVideoError):
            return {
                ...state,
                videoError: {
                    ...state.videoError,
                    [action.payload.document]: action.payload.value,
                },
            };

        default:
            return state;
    }
};

export default uiReducer;
