let serviceLocator = null;

class ServiceLocator {
    set validateAndCollect(callback) {
        this._validateAndCollect = callback;
    }

    get validateAndCollect() {
        return this._validateAndCollect;
    }

    get ProxyREST() {
        return this._ProxyREST;
    }

    get ChecksREST() {
        return this._ChecksREST;
    }

    get DataREST() {
        return this._DataREST;
    }

    constructor({ ProxyREST, ChecksREST, DataREST }) {
        this._ProxyREST = ProxyREST;
        this._ChecksREST = ChecksREST;
        this._DataREST = DataREST;
    }
}

function serviceLocatorFactory(settings, { replace = false } = {}) {
    if (serviceLocator !== null && replace !== true) {
        throw new Error('Service locator has already been created.');
    }
    serviceLocator = new ServiceLocator(settings);
    return serviceLocator;
}

export { serviceLocatorFactory, serviceLocator };
