import { cacheFactory } from '../Cache';
import { deepClone } from '../../utils/fn';

export class AbstractREST {
    constructor({ baseUrl, namespace = 'rest' }) {
        if (baseUrl) {
            this._baseUrl = baseUrl;
            this._cache = cacheFactory(namespace);
        } else {
            throw new Error('baseUrl is not specified');
        }
    }

    createUrl(url) {
        return /^https?:\/\//.test(url) ? url : `${this._baseUrl}/${url}`;
    }

    // eslint-disable-next-line no-unused-vars
    async _fetch(url, options) {}

    /**
     * Allow
     * @param url
     * @param options
     * @returns {Promise<void>}
     * @protected
     */
    async _cachedFetch(url, options = {}) {
        const key = { url, options };

        let promise = this._cache.get(key);

        if (!promise) {
            promise = this._fetch(url, options);
        }

        this._cachePromise(promise, key);
        return promise;
    }

    _cachePromise(promise, key) {
        const clearCache = (data) => {
            this._cache.del(key);
            return data;
        };
        const cachedPromise = new Promise((resolve, reject) => {
            promise.then((data) => resolve(deepClone(data)), reject);
        }).then(clearCache, clearCache);

        this._cache.set(key, cachedPromise);
    }

    // eslint-disable-next-line no-unused-vars
    async create(url, data) {}

    // eslint-disable-next-line no-unused-vars
    async read(url, options) {}

    // eslint-disable-next-line no-unused-vars
    async update(url, data) {}

    // eslint-disable-next-line no-unused-vars
    async delete(url) {}

    async request(url, options) {
        return this._fetch(url, options);
    }
}
