/* eslint-disable camelcase */
import { TaskPageController } from './TaskPageController';

// eslint-disable-next-line no-undef
export default class DriveTask extends TolokaTask {
    render() {
        this.initController();
        document.head.appendChild(this.getStyleDOMElement());

        this.onRender();
        this.hotkey.destroy();

        return this;
    }

    initController() {
        const taskSuite = this.getAssignment().getTaskSuite();

        this.controller = new TaskPageController({
            element: this.getDOMElement(),
            input: this.getTask().input_values,
            facts: taskSuite.getFacts(),
            scaleOptions: taskSuite.getScaleOptions(),
        });

        if (this.controller) {
            this.controller.run();
        }
    }

    onDestroy() {
        if (this.controller) {
            this.controller.destroy();
        }
    }

    getSolution() {
        const { verdicts, comments: other } = this.controller.getResults();

        return {
            task_id: this.getTask().id,
            output_values: {
                verdicts,
                other,
            },
        };
    }

    async validate(solutions) {
        try {
            await this.controller.validateAndCollect();
        } catch {
            return { task_id: this.getOptions().task.id, errors: {} };
        }

        return super.validate(solutions);
    }

    /**
     * @param {SolutionValidationError} errors
     */
    onValidationFail(errors) {
        super.onValidationFail(errors);

        Object.keys(errors.errors).forEach((fieldName) => {
            if (fieldName === '__TASK__') {
                this.controller.showTaskError(errors.errors[fieldName]?.message || errors.errors[fieldName]);
            }
        });
    }
}
