import { createElement } from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { serviceLocator } from '../infrastructure/serviceLocator';
import { initStore, resetStore, store } from '../domain/store';
import { setTaskError } from '../domain/store/actions/ui';
import { TaskView } from '../components/TaskView';

export class TaskPageController {
    constructor({ element, input, facts, scaleOptions }) {
        this.element = element;
        this.input = input;
        this.facts = facts;
        this.scaleOptions = scaleOptions;
    }

    get view() {
        return this._view;
    }

    createView() {
        this._view = render(createElement(TaskView), this.element);
    }

    getResults() {
        return store.getState().solution || {};
    }

    run() {
        initStore(this.input, this.facts, this.scaleOptions);
        this.createView();
    }

    destroy() {
        unmountComponentAtNode(this.element);

        if (this.element.parentNode) {
            this.element.parentNode.removeChild(this.element);
        }

        resetStore();
    }

    showTaskError(message) {
        store.dispatch(setTaskError(message));
    }

    async validateAndCollect() {
        return serviceLocator.validateAndCollect();
    }
}
