import dayjs from 'dayjs';
import relativeTime from 'dayjs/plugin/relativeTime';

dayjs.extend(relativeTime);

export const formatHRTime = (isoTime) => dayjs(isoTime).fromNow();

export const formatAbsTime = (isoTime) => dayjs(isoTime).format('DD MMM YYYY, HH:MM');

export const formatISOTime = (timestamp) => dayjs(timestamp).format('YYYY-MM-DDTHH:mm:ss.SSSZ');
