import i18 from 'i18next';
import { initReactI18next } from 'react-i18next';
import { createTranslationKeys } from '../../i18n';
import enUS from 'antd/lib/locale-provider/en_US';
import ruRU from 'antd/lib/locale-provider/ru_RU';
import dateRU from 'dayjs/locale/ru';
import dateEN from 'dayjs/locale/en-gb';
import dayjs from 'dayjs';

const antdlocaleMap = {
    ru: ruRU,
    en: enUS,
};

const datelocaleMap = {
    ru: dateRU,
    en: dateEN,
};

export const i18next = i18.createInstance();

i18next.on('languageChanged', (lng) => {
    i18next.antdLocale = antdlocaleMap[lng];
    dayjs.locale(datelocaleMap[lng]);
});

export const i18nextInit = ({ lng = 'ru', debug = false, userKeys = {} }) =>
    i18next.use(initReactI18next).init({
        lng,
        debug,
        compatibilityJSON: 'v1',
        resources: createTranslationKeys(userKeys),
    });

/**
 *
 * Simple wrapper for i18next.t
 * This will only work with initially set language
 * But this is okay for Toloka/Yang, since workspace is destroyed when user changes language
 *
 * @param {string} key
 * @param {object} options
 * @returns {string}
 */
export const translate = (key, options = {}) => i18next.t(key, options);
