exports.Assignment = extend(
    Drive.Assignment,
    function(options) {
        Drive.Assignment.call(this, options);
    },
    {},
);

exports.Task = extend(
    Drive.Task,
    function(options) {
        Drive.Task.call(this, options);
    },
    {},
);

exports.TaskSuite = extend(
    Drive.TaskSuite,
    function(options) {
        Drive.TaskSuite.call(this, options);
    },
    {
        getUserLocale: function() {
            return {
                ru: {
                    verdict_ok: 'Все хорошо',
                    "common_task_title": "Каршеринг. Одиночная проверка видео",
                    "license_front": "Документ",
                    "license_back": "Документ",
                    "passport_biographical": "Документ",
                    "passport_registration": "Документ",
                    "passport_selfie": "Селфи с документом",
                    "license_selfie": "Селфи с документом"
                },
                en: {
                    verdict_ok: 'All OK',
                    "common_task_title": "Carsharing. Single video check",
                    "license_front": "Document",
                    "license_back": "Document",
                    "passport_biographical": "Document",
                    "passport_registration": "Document",
                    "passport_selfie": "Selfie with document",
                    "license_selfie": "Selfie with document"
                },
            }
        },
        getFacts: function() {
            return {
                passport_biographical: {
                    VIDEO_ERROR: 'Ошибка видео',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    NO_OBJECT: 'Нет документа',

                },
                passport_registration: {
                    VIDEO_ERROR: 'Ошибка видео',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    NO_OBJECT: 'Нет документа',
                },
                passport_selfie: {
                    VIDEO_ERROR: 'Ошибка видео',
                    SCREENCAP_SELFIE: 'Экранка селфи',
                    NO_OBJECT: 'Нет документа и/или человека',
                    NOT_ORIGINAL: 'Не оригинал документа',

                },
                license_front: {
                    VIDEO_ERROR: 'Ошибка видео',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    NO_OBJECT: 'Нет документа',
                },
                license_back: {
                    VIDEO_ERROR: 'Ошибка видео',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    NO_OBJECT: 'Нет документа',
                },
                license_selfie: {
                    VIDEO_ERROR: 'Ошибка видео',
                    SCREENCAP_SELFIE: 'Экранка селфи',
                    NO_OBJECT: 'Нет документа и/или человека',
                    NOT_ORIGINAL: 'Не оригинал документа'
                },
            };
        },

        getProxyNames: function() {
            return {
                checks: 'robot-yang-cars-registration-documents-checks/set_status',
                data: 'robot-yang-cars-registration-data',
                media: 'robot-yang-cars-registration',
            }
        },

        getScaleOptions: function() {
            return {
                multipleSelect: false,
                otherWithComment: true,
            }
        },

        getSetStatusType: function () {
            return {
                passport_biographical: "passport_biographical_video",
                passport_registration: "passport_registration_video",
                passport_selfie: "passport_selfie_video",
                license_front: "license_front_video",
                license_back: "license_back_video",
                license_selfie: "license_selfie_video",
            };
        },
    },
);

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function() {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
