﻿const path = require('path');
const fs = require('fs');

module.exports = {
    certPath: path.resolve(__dirname, './ssl/dev.pem'),
    project: {
        title: 'Ya.Drive: Video checking',
        description: 'Toloka template for Drive video checking',
        instructions: 'TBD',
        hideSkip: true,
        markup: path.resolve(process.cwd(), './static/markup.hbs'),
        styles: path.resolve(process.cwd(), './static/styles.css'),
        script: path.resolve(process.cwd(), './static/script.js'),
        scriptUrls: ['https://local.yang.yandex-team.ru:3002/template-drive-video-checking.js'],
        tasks: [
            {
                id: 0,
                input_values: {
                    secret: 'foo',
                    user_id: 'b9eb0604-7594-4a11-98c0-0279b6432cc8',
                    task_type: 'registration_on_chat',
                    document_types: [
                        'license_selfie',
                    ],
                },
            },
        ],
        outputSpec: {
            verdicts: {
                type: 'json',
                required: true,
                hidden: false,
            },
            other: {
                type: 'json',
                required: false,
                hidden: false,
            },
        },
        middleware: {
            before: [
                {
                    path: new RegExp(
                        '^/api/proxy/robot-yang-cars-registration-data/assignment/document_data?(.+)',
                    ),
                    handler: (req, res, next) => {
                        const filePath = path.resolve(__dirname, `./mocks/small.mp4`);

                        res.header('Cache-Control', 'private, no-cache, no-store, must-revalidate');
                        res.header('Expires', '-1');
                        res.header('Pragma', 'no-cache');

                        return fs.existsSync(filePath) ? res.end(fs.readFileSync(filePath)) : next();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-documents-checks/set_status(.+)'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/queue?(.+)'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
            ],
        },
    },
};
