#include "client.h"

bool TAdjustClient::RegisterEvent(const TString& eventToken, const TString& userToken, const TString& tokenType, const TInstant timestamp) const {
    SendAsyncRequest(eventToken, CreateSendEventRequest(eventToken, userToken, tokenType, timestamp));
    return true;
}

NNeh::THttpRequest TAdjustClient::CreateSendEventRequest(const TString& eventToken, const TString& userToken, const TString& tokenType, const TInstant timestamp) const {
    NNeh::THttpRequest request = TBase::CreateCommonRequest("event");
    request.AddCgiData("&event_token=" + eventToken);
    request.AddCgiData("&created_at_unix=" + ToString(timestamp.Seconds()));
    request.AddCgiData("&" + tokenType + "=" + userToken);
    return request;
}
