#pragma once

#include "config.h"

#include <rtline/library/deprecated/async_impl/client.h>

class TAdjustClient : public TRequestClient<TAdjustClientConfig, TRequestLogger<TString>> {
    using TBase = TRequestClient<TAdjustClientConfig, TRequestLogger<TString>>;

public:
    TAdjustClient(const TAdjustClientConfig& config)
        : TBase(config, "adjust_api")
    {}

    bool RegisterEvent(const TString& eventToken, const TString& userToken, const TString& tokenType, const TInstant timestamp) const;

private:
    NNeh::THttpRequest CreateSendEventRequest(const TString& eventToken, const TString& userToken, const TString& tokenType, const TInstant timestamp) const;
};
