#include "config.h"

void TAdjustClientConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy) {
    TBase::Init(section, requestPolicy);
    AppToken = section->GetDirectives().Value("AppToken", AppToken);
    AssertCorrectConfig(!!AppToken, "AppToken undefined");
    const TYandexConfig::TSectionsMap sections = section->GetAllChildren();
}

void TAdjustClientConfig::ToString(IOutputStream& os) const {
    TBase::ToString(os);
    os << "AppToken: " << AppToken << Endl;
}

void TAdjustClientConfig::Authorize(NNeh::THttpRequest& request) const {
    request.AddCgiData("&app_token=" + AppToken + "&s2s=1");
}
