#pragma once

#include <rtline/library/deprecated/async_impl/config.h>

class TAdjustClientConfig : public TRequestConfig {
    using TBase = TRequestConfig;
    R_READONLY(TString, AppToken);

public:
    TAdjustClientConfig()
        : TBase(TDuration::Seconds(60))
    {}

    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;
    void Authorize(NNeh::THttpRequest& request) const;

    static TAdjustClientConfig ParseFromString(const TString& configStr) {
        return TBase::ParseFromString<TAdjustClientConfig>(configStr);
    }
};
