#pragma once

#include <library/cpp/logger/global/global.h>
#include <util/generic/maybe.h>

class TCryptoGCMProcessor {
public:
    enum class EMode {
        GCM_128,
        GCM_256
    };

    struct Encrypted {
        TString Tag;
        TString Data;
        Encrypted() = default;
        Encrypted(const TString& tag, const TString& data)
            : Tag(tag)
            , Data(data)
        {
        }
    };

private:
    EMode Mode;
    TVector<unsigned char> EncryptionKey;

public:
    TCryptoGCMProcessor(const EMode mode, const unsigned char* encryptionKey);
    TCryptoGCMProcessor(const EMode mode, const TVector<unsigned char>& encryptionKey);
    TMaybe<TString> Decrypt(const TString& encryptedContent, const TString& iv, const TString& tag) const;
    TMaybe<Encrypted> Encrypt(const TString& content, const TString& iv) const;

    static ui8 HexDigitToInt(const char digit);
};
