#include <drive/library/cpp/aes/crypto.h>

#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>


Y_UNIT_TEST_SUITE(Cryptography) {
    Y_UNIT_TEST(SimpleAES) {
        TString textForEncryption = "abcdefghijklmnopqrstuvwxyz1234567890";
        TString iv = "1234567890ab--12783";
        TString encryptionKey = "00000000000000000000000000000000";

        auto processor = TCryptoGCMProcessor(TCryptoGCMProcessor::EMode::GCM_256, (unsigned char*)encryptionKey.data());

        auto encrypted = processor.Encrypt(textForEncryption, iv);
        UNIT_ASSERT(encrypted);
        unsigned char correntEncryptionResult[36] = {
            242, 72, 166, 38, 159, 243, 226, 229, 209, 100, 170, 203, 251, 129, 95, 18, 5,
            241, 53, 121, 193, 163, 213, 11, 241, 135, 7, 139, 33, 6, 7, 102, 68, 152, 109, 10
        };

        UNIT_ASSERT_VALUES_EQUAL(encrypted->Data.size(), 36);
        for (size_t i = 0; i < 36; ++i) {
            UNIT_ASSERT_VALUES_EQUAL((unsigned char)encrypted->Data[i], correntEncryptionResult[i]);
        }

        auto decryptedString = processor.Decrypt(encrypted->Data, iv, encrypted->Tag);
        UNIT_ASSERT(decryptedString);
        UNIT_ASSERT_VALUES_EQUAL(*decryptedString, textForEncryption);
    }
}
