#include "tvm.h"

#include <rtline/util/network/neh.h>

namespace NDrive {

void UpdateRequest(NNeh::THttpRequest& request, IAuth::TPtr auth) {
    if (auth) {
        auth->UpdateRequest(request);
    }
}

TOAuthToken::TOAuthToken(const TString& token)
    : Token(token)
{
}

void TOAuthToken::UpdateRequest(NNeh::THttpRequest& request) const {
    request.SetOAuthToken(Token);
}

TTvmAuth::TTvmAuth(
    TAtomicSharedPtr<NTvmAuth::TTvmClient> client,
    NTvmAuth::TTvmId destinationTvmId
)
    : Client(client)
    , DestinationTvmId(destinationTvmId)
{
}

void TTvmAuth::UpdateRequest(NNeh::THttpRequest& request) const {
    request.AddHeader("X-Ya-Service-Ticket", Yensured(Client)->GetServiceTicketFor(DestinationTvmId));
}

}
