#pragma once

#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/ptr.h>

namespace NNeh {
    class THttpRequest;
}

namespace NDrive {

    class IAuth {
    public:
        using TPtr = TAtomicSharedPtr<IAuth>;

        virtual ~IAuth() = default;

        virtual void UpdateRequest(NNeh::THttpRequest& request) const = 0;
    };

    // UpdateRequest updates request with specified auth method.
    //
    // You can safely pass nullptr without any error.
    void UpdateRequest(NNeh::THttpRequest& request, IAuth::TPtr auth);

    class TOAuthToken : public IAuth {
    public:
        TString Token;

        TOAuthToken(const TString& token);

        // UpdateRequest adds header with OAuth token to the request.
        void UpdateRequest(NNeh::THttpRequest& request) const override;
    };

    class TTvmAuth : public IAuth {
    public:
        TAtomicSharedPtr<NTvmAuth::TTvmClient> Client;
        NTvmAuth::TTvmId DestinationTvmId = 0;

        TTvmAuth(
            TAtomicSharedPtr<NTvmAuth::TTvmClient> client,
            NTvmAuth::TTvmId destinationTvmId
        );

        // UpdateRequest adds TVM auth header to the request.
        void UpdateRequest(NNeh::THttpRequest& request) const override;
    };

}
