#pragma once

#include <rtline/library/deprecated/async_impl/config.h>

namespace NDrive::NAutocode {
    class TAutocodeClientConfig {
    public:
        class TEvacuationApiConfig : public TRequestConfig {
            using TBase = TRequestConfig;

            R_READONLY(TString, Uri, "/api/evacuation");

        public:
            void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
            void ToString(IOutputStream& os) const;
        };

        class TDriverLicenseApiConfig : public TRequestConfig {
            using TBase = TRequestConfig;

            R_READONLY(TString, InfoUri, "/mosru/api/driverlicenses");

        public:
            void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
            void ToString(IOutputStream& os) const;
        };

        class TFinesApiConfig : public TRequestConfig {
            using TBase = TRequestConfig;

            R_READONLY(TString, SubscriptionUri, "/api/Subscribers/Add");
            R_READONLY(TString, UnsubscriptionUri, "/api/Subscribers/Remove");
            R_READONLY(TString, FinesUri, "/api/Penalties/Get");
            R_READONLY(TString, PaidFinesUri, "/api/Penalties/GetPaid");
            R_READONLY(TString, FinePhotosUri, "/api/PenaltyPhotos/Get");
            R_READONLY(TString, FinesReceivedConfirmationUri, "/api/Penalties/ConfirmReceived");

        public:
            void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
            void ToString(IOutputStream& os) const;
        };

        const TEvacuationApiConfig* GetEvacuationApiConfig() const {
            return EvacuationApiConfig.Get();
        }

        const TDriverLicenseApiConfig* GetDriverLicenseApiConfig() const {
            return DriverLicenseApiConfig.Get();
        }

        const TFinesApiConfig* GetFinesApiConfig() const {
            return FinesApiConfig.Get();
        }

        void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
        void ToString(IOutputStream& os) const;

        static TAutocodeClientConfig ParseFromString(const TString& configStr);

    private:
        TAtomicSharedPtr<TEvacuationApiConfig> EvacuationApiConfig;
        TAtomicSharedPtr<TDriverLicenseApiConfig> DriverLicenseApiConfig;
        TAtomicSharedPtr<TFinesApiConfig> FinesApiConfig;

        R_READONLY(TFsPath, SecretPath);
        R_READONLY(TString, Secret);
        R_READONLY(TString, ServiceId, "yandex");
    };
}
