#pragma once

#include <rtline/util/json_processing.h>
#include <rtline/util/types/accessor.h>

#include <util/memory/blob.h>

namespace NDrive::NAutocode {
    class TAutocodeFine {
    public:
        R_READONLY(TString, AppealUrl);
        R_READONLY(TString, ArticleKoap);
        R_READONLY(TInstant, DiscountDate);       // UTC

        R_READONLY(TString, FineInfoUrl);
        R_READONLY(bool, HasPhoto, false);
        R_READONLY(i64, Id, 0);
        R_READONLY(TString, OdpsCode);
        R_READONLY(TString, OdpsName);
        R_READONLY(TString, PayUrl);
        R_READONLY(TInstant, RulingDate);       // UTC

        R_READONLY(TString, RulingNumber);
        R_READONLY(double, SumToPay, 0);
        R_READONLY(TInstant, ViolationDate);       // UTC

        R_READONLY(TInstant, ViolationDateWithTime);
        R_READONLY(ui64, ViolationDocumentNumber, 0);
        R_READONLY(TString, ViolationDocumentType);
        R_READONLY(TString, ViolationPlace);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& data);
    };

    class TAutocodeFinePhoto {
        R_READONLY(TString, Data);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& data);
    };

    class TEvacuationInfo {
        R_READONLY(bool, EmptyResult, false);

        R_READONLY(bool, Evacuated, false);

        R_READONLY(TString, ViolationArticleCode);
        R_READONLY(TString, ViolationArticleName);
        R_READONLY(TString, ViolationArticleTitle);
        R_READONLY(TString, ViolationAddress);
        R_READONLY(TInstant, FixationDate);

        R_READONLY(TString, ParkingLotAddress);
        R_READONLY(TString, DepartmentName);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& data);

        TString GetHRReport(const TString& defaultReport = "") const;
    };

    class TDriverLicenseInfo {
        R_READONLY(bool, EmptyResult, false);

        R_READONLY(TInstant, IssueDate);       // UTC

        R_READONLY(TInstant, EndDate);       // UTC


        R_READONLY(TString, IssuingState);
        R_READONLY(ui32, YearExperienceFrom, 0);
        R_READONLY(TString, AllowedCategories);       // set of category one-letter (russian or even mixed) identifiers


        R_READONLY(TInstant, DeprivationDate);       // UTC

        R_READONLY(ui32, DeprivationCount, 0);

        R_READONLY(TString, Status);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& data);
        NJson::TJsonValue SerializeToJson() const;
    };
}
