#include "init.h"

#include <library/cpp/logger/global/global.h>

#include <aws/core/Aws.h>

#include <util/generic/singleton.h>

#include <mutex>

class TAwsGuard::TInitializer {
public:
    TInitializer() {
        INFO_LOG << "Initializing AWS" << Endl;
        Aws::InitAPI(Options);
    }
    ~TInitializer() {
        INFO_LOG << "Shutting down AWS" << Endl;
        Aws::ShutdownAPI(Options);
    }

private:
    Aws::SDKOptions Options;
};

TAwsGuard::TAwsGuard(std::shared_ptr<TInitializer>&& impl)
    : Impl(std::move(impl))
{
}

TAwsGuard::~TAwsGuard() {
}

namespace {
    class TGlobalAwsInitializer {
    public:
        TAwsGuard Get() {
            std::unique_lock lock(Mutex);
            auto result = Value.lock();
            if (!result) {
                result = std::make_shared<TAwsGuard::TInitializer>();
                Value = result;
            }
            return result;
        }

    private:
        std::weak_ptr<TAwsGuard::TInitializer> Value;
        std::mutex Mutex;
    };
}

TAwsGuard InitializeAws() {
    return Singleton<TGlobalAwsInitializer>()->Get();
}
