#pragma once

#include "info.h"

#include <rtline/util/network/neh.h>

#include <library/cpp/blackbox2/blackbox2.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/array_ref.h>

namespace NBlackbox2 {
    class TResponse;
}

namespace NDrive {
    class TBlackboxClient {
    public:
        using TResponsePtr = TAtomicSharedPtr<NBlackbox2::TResponse>;

    public:
        TBlackboxClient(TStringBuf endpoint, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm, TAtomicSharedPtr<TAsyncDelivery> ad = nullptr);

        NThreading::TFuture<TResponsePtr> LoginInfoRequest(TStringBuf login, TStringBuf userIp) const;
        NThreading::TFuture<TResponsePtr> UidInfoRequest(TStringBuf uid, TStringBuf userIp) const;
        NThreading::TFuture<TResponsePtr> OAuthRequest(TStringBuf token, TStringBuf userIp) const;
        NThreading::TFuture<TResponsePtr> SessionIdRequest(TStringBuf sessionId, TStringBuf userIp) const;

        TBlackboxInfo Parse(const NBlackbox2::TResponse& response) const;

        void EnableUserTickets();
        void SetDestinationClientId(NTvmAuth::TTvmId value);
        void SetCookieHost(const TString& value);
        void SetScopes(TConstArrayRef<TString> values);
        void SetExternalOptions(const NBlackbox2::TOptions& extOptions);

    private:
        NThreading::TFuture<NUtil::THttpReply> MakeRequest(const TString& request) const;

    private:
        const TAtomicSharedPtr<NNeh::THttpClient> HttpClient;
        const TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;

        NBlackbox2::TOptions Options;

        NTvmAuth::TTvmId DestinationClientId = 0;
        TString CookieHost;
        TString Path;
        bool UserTicketsEnabled = false;
    };
}
