#pragma once

#include <drive/library/cpp/raw_text/datetime.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/messages_collector.h>

#include <util/generic/hash.h>
#include <util/generic/set.h>

namespace NDrive {
    class TScheme;
}

namespace NJson {
    class TJsonValue;
}

namespace NCalendarRestriction {
    /*
    Refer to calendars here:
        rtline/library/time_restriction
        yweb/morda_blender/calendar.h
    */

    enum class EWeekDay {
        Monday /* "Monday" */,
        Tuesday /* "Tuesday" */,
        Wednesday /* "Wednesday" */,
        Thursday /* "Thursday" */,
        Friday /* "Friday" */,
        Saturday /* "Saturday" */,
        Sunday /* "Sunday" */,
    };

    static const EWeekDay WeekDays[] = { EWeekDay::Monday, EWeekDay::Tuesday, EWeekDay::Wednesday, EWeekDay::Thursday, EWeekDay::Friday, EWeekDay::Saturday, EWeekDay::Sunday };
    static const THashMap<EWeekDay, size_t> WeekDaysMapping = {
        { EWeekDay::Monday, 0 },
        { EWeekDay::Tuesday, 1 },
        { EWeekDay::Wednesday, 2 },
        { EWeekDay::Thursday, 3 },
        { EWeekDay::Friday, 4 },
        { EWeekDay::Saturday, 5 },
        { EWeekDay::Sunday, 6 },
    };

    class TCalendarRestriction {
    private:
        R_FIELD(NUtil::TTimeZone, TimeZone, GetDefaultTimeZone());
        R_FIELD(ui32, DayTimeSinceMinutes, 0);
        R_FIELD(ui32, DayTimeUntilMinutes, 0);
        R_FIELD(TSet<ui32>, DayOfWeekFilter);
        R_FIELD(TSet<ui32>, HolidayFilter);       // to be extended and reworked (at least depend on country)


    public:
        bool Check(const TInstant instant, TMessagesCollector& foundRestrictions) const;

        static NDrive::TScheme GetScheme();
        static NUtil::TTimeZone GetDefaultTimeZone();

        bool DeserializeFromJson(const NJson::TJsonValue& data);
        NJson::TJsonValue SerializeToJson() const;
    };
}
