#pragma once

#include <catboost/libs/model/model.h>

namespace NCatboostCalcer {
    class TMulticlassPredictor {
    public:
        struct TResult {
            size_t ClassId = static_cast<size_t>(-1);
            double RawValue = 0;
        };

    public:
        TMulticlassPredictor() = default;
        TMulticlassPredictor(const TFullModel& model)
            : Model(model)
        {
        }
        TMulticlassPredictor(TFullModel&& model)
            : Model(std::move(model))
        {
        }

        const TFullModel& GetModel() const {
            return Model;
        }

        TVector<double> CalcRaw(TConstArrayRef<float> floatFeatures, const TVector<TStringBuf>& catFeatures) const;
        TMaybe<TResult> Predict(TConstArrayRef<float> floatFeatures, const TVector<TStringBuf>& catFeatures) const;

        void Save(IOutputStream *out) const;
        void Load(IInputStream *in);

    private:
        TFullModel Model;
    };
}
