#include "multiclass.h"

#include <rtline/util/algorithm/container.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/stream/file.h>

Y_UNIT_TEST_SUITE(CatboostMulticlassSuite) {
    Y_UNIT_TEST(Simple) {
        NCatboostCalcer::TMulticlassPredictor predictor;
        {
            auto path = TFsPath(GetWorkPath()) / "da573" / "region_predictor.v3.cbm";
            TIFStream file(path);
            predictor.Load(&file);
        }
        TVector<float> floats(41, 1);
        TVector<TString> categories(4);
        auto rawValues = predictor.CalcRaw(floats, MakeVector<TStringBuf>(categories));
        UNIT_ASSERT_VALUES_EQUAL(rawValues.size(), 8);
    }
}
