#include "client.h"

#include <library/cpp/string_utils/quote/quote.h>

bool TClckClient::Compress(const TString& deeplink, TString& shortLink, TMessagesCollector& errors) const {
    NJson::TJsonValue jsonReply;
    if (!SendRequest(EClckOperationType::Compress, CreateCommonRequest("--").SetCgiData("url=" + UrlEscapeRet(deeplink, true)), jsonReply, errors)) {
        return false;
    }
    const TString reportLink = jsonReply.GetStringRobust();
    if (reportLink) {
        shortLink = reportLink;
    }
    return !!reportLink;
}
