#pragma once

#include <rtline/library/deprecated/async_impl/client.h>

enum EClckOperationType {
    Compress /* "compress" */,
};

class TClckLogger : public TRequestLogger<EClckOperationType> {
    using TBase = TRequestLogger<EClckOperationType>;

public:
    TClckLogger(const TString& source)
        : TBase(source, "clck_api")
    {}
};


class TClckClientConfig : public TRequestConfig {
    using TBase = TRequestConfig;

public:
    TClckClientConfig()
        : TBase(TDuration::Seconds(60))
    {}
};

class TClckRequestCallback : public TRequestCallback<EClckOperationType, TClckLogger> {
    using TBase = TRequestCallback<EClckOperationType, TClckLogger>;
public:
    using TBase::TBase;

    virtual bool ParseResult(const TString& report) override {
        Result = report;
        return true;
    }
};

class TClckClient : public TRequestClient<TClckClientConfig, TClckLogger, EClckOperationType, TClckRequestCallback> {
    using TBase = TRequestClient<TClckClientConfig, TClckLogger, EClckOperationType, TClckRequestCallback>;
public:
    TClckClient(const TClckClientConfig& config)
        : TBase(config, "clck_api")
    {}

    bool Compress(const TString& deeplink, TString& shortDeeplink, TMessagesCollector& errors) const;
};
