#pragma once

#include "config.h"

#include <rtline/util/types/messages_collector.h>

#include <util/generic/guid.h>

enum EClearWebVerdict {
    TextAutoGood /* "text_auto_good" */,
    TextAutoBad /* "text_auto_bad" */,
};

class TClearWebClient {
public:
    class TResponse {
    public:
        TResponse(ui32 code, const TString& content);

        NJson::TJsonValue GetJsonContent() const;
        NJson::TJsonValue SerializeToJson() const;

    private:
        R_FIELD(ui32, Code, 0);
        R_FIELD(TString, Content);
    };

public:
    TClearWebClient(const TClearWebClientConfig& config);
    ~TClearWebClient();

    ui32 CheckText(const TString& text, bool& isValid, TMessagesCollector& errors) const;
    NThreading::TFuture<TResponse> CheckText(const TString& text) const;
    const TClearWebClientConfig& GetConfig() const;

private:
    TClearWebClientConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;
};
