#include "config.h"

void TClearWebClientConfig::Init(const TYandexConfig::Section* section) {
    const auto& directives = section->GetDirectives();
    Host = directives.Value("Host", Host);
    Port = directives.Value("Port", Port);
    VersionUri = directives.Value("VersionUri", VersionUri);
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    {
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }
    RequestTimeout = directives.Value<TDuration>("RequestTimeout", RequestTimeout);
    ServiceName = directives.Value("ServiceName", ServiceName);
    DataType = directives.Value("DataType", DataType);
    TestFieldName = directives.Value("TestFieldName", TestFieldName);
}

void TClearWebClientConfig::ToString(IOutputStream& os) const {
    os << "Host: " << Host << Endl;
    os << "Port: " << Port << Endl;
    os << "VersionUri: " << VersionUri << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "ServiceName: " << ServiceName << Endl;
    os << "DataType: " << DataType << Endl;
    os << "TestFieldName: " << TestFieldName << Endl;
}

TClearWebClientConfig TClearWebClientConfig::ParseFromString(const TString& configStr) {
    TClearWebClientConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
