#pragma once

#include <kernel/multipart_archive/config/config.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>
// #include <kernel/multipart_archive/queue/queue_storage.h>


class TClearWebClientConfig {
    R_READONLY(TString, Host, "cw-router-dev.common.yandex.net");
    R_READONLY(ui32, Port, 443);
    R_READONLY(TString, VersionUri, "/v2/");
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(10));
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(TString, ServiceName, "drive");
    R_READONLY(TString, DataType, "promo");
    R_READONLY(TString, TestFieldName, "text");

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TClearWebClientConfig ParseFromString(const TString& configStr);
};

