#include <drive/library/cpp/clear_web/client.h>

#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>


Y_UNIT_TEST_SUITE(ClearWebSuite) {
    TClearWebClientConfig GetClientConfig() {
        auto config = TStringBuilder()
            << "Host: " << GetEnv("ApiHost", "cw-router-dev.common.yandex.net") << Endl
            << "ServiceName: " << GetEnv("ServiceName", "drive") << Endl
            << "TestFieldName: " << GetEnv("TestFieldName", "text") << Endl
            << "DataType: " << GetEnv("DataType", "promo") << Endl
            << "<RequestConfig>" << Endl
            << "MaxAttempts: 1" << Endl
            << "</RequestConfig>" << Endl;
        INFO_LOG << config << Endl;
        return TClearWebClientConfig::ParseFromString(config);
    }

    Y_UNIT_TEST(SimpleOperations) {
        const TClearWebClient cwClient(GetClientConfig());
        TMessagesCollector errors;
        {
            bool result = false;
            const TString normalWord = "text";
            UNIT_ASSERT_VALUES_EQUAL_C(cwClient.CheckText(normalWord, result, errors) / 100, 2, errors.GetStringReport());
            UNIT_ASSERT(result);
        }
        {
            bool result = false;
            const TString wrongWord = "fuckup";
            UNIT_ASSERT_VALUES_EQUAL_C(cwClient.CheckText(wrongWord, result, errors) / 100, 2, errors.GetStringReport());
            UNIT_ASSERT(!result);
        }
    }
}
