#pragma once

#include "options.h"

#include <library/cpp/clickhouse/client/block.h>
#include <library/cpp/threading/future/future.h>
#include <rtline/library/storage/sql/transaction.h>

namespace NNeh {
    class THttpClient;
}

namespace NSQL {
    struct TQueryOptions;
}

namespace NClickHouse {
    class TSimpleQuoter: public NSQL::IQuoter {
    public:
        static const NSQL::IQuoter& Instance() {
            return *Singleton<TSimpleQuoter>();
        }

    public:
        TString Quote(const TString& data) const override {
            return TStringBuilder() << "'" << data << "'";
        }
    };

    class TAsyncClient {
    public:
        TAsyncClient(const TAsyncClientOptions& options);
        ~TAsyncClient();

        NThreading::TFuture<TBlock> Execute(TStringBuf query, TInstant deadline = TInstant::Zero()) const;
        NThreading::TFuture<TBlock> Select(TStringBuf table, const NSQL::TQueryOptions& queryOptions, TInstant deadline = TInstant::Zero()) const;

    private:
        const TAsyncClientOptions Options;

        THolder<NNeh::THttpClient> Client;
    };

    template <class T>
    T GetColumnValue(TColumnRef column, size_t index);
}
