#pragma once

#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NClickHouse {
    struct TAsyncClientOptions {
        TVector<TString> Endpoints;
        TString Database;
        TString User;
        TString Password;
        TMaybe<size_t> MaxMemoryUsage;
        TDuration Timeout = TDuration::Seconds(1);
    };
}
