#include "object_sharding.h"

#include <util/digest/fnv.h>

TObjectSharding::TObjectSharding(const ui32 minShard, const ui32 maxShard)
    : MinShard(minShard)
    , MaxShard(maxShard)
{
}

NDrive::TScheme TObjectSharding::GetScheme() {
    NDrive::TScheme scheme;
    scheme.Add<TFSNumeric>("min_shard", "Левая граница пользователей эксперимента [0, Max<ui16>())").SetMin(0).SetMax(Max<ui16>() + 1).SetDefault(0);
    scheme.Add<TFSNumeric>("max_shard", "Правая граница пользователей эксперимента [0, Max<ui16>())").SetMin(0).SetMax(Max<ui16>() + 1).SetDefault(Max<ui16>() + 1);
    return scheme;
}

bool TObjectSharding::DeserializeFromJson(const NJson::TJsonValue& info) {
    JREAD_INT_OPT(info, "min_shard", MinShard);
    JREAD_INT_OPT(info, "max_shard", MaxShard);
    if (MinShard > MaxShard) {
        return false;
    }
    return true;
}

NJson::TJsonValue TObjectSharding::SerializeToJson() const {
    NJson::TJsonValue result;
    result.InsertValue("min_shard", MinShard);
    result.InsertValue("max_shard", MaxShard);
    return result;
}

bool TObjectSharding::CheckMatching(const TString& objectId) const {
    const ui16 hash = FnvHash<ui32>(objectId.c_str(), objectId.size());
    return (hash >= MinShard && hash < MaxShard) || (MinShard == MaxShard);
}
