#pragma once

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/types/accessor.h>

class TObjectSharding {
private:
    R_FIELD(ui32, MinShard, 0);
    R_FIELD(ui32, MaxShard, Max<ui16>() + 1);

public:
    TObjectSharding() = default;
    TObjectSharding(const ui32 minShard, const ui32 maxShard);

    static NDrive::TScheme GetScheme();
    bool DeserializeFromJson(const NJson::TJsonValue& info);
    NJson::TJsonValue SerializeToJson() const;

    bool CheckMatching(const TString& objectId) const;
};
