#include "status.h"

#include <rtline/library/json/adapters.h>

#include <util/string/cast.h>

NDrive::ECarStatus NDrive::GetStatus(TStringBuf url) {
    NDrive::ECarStatus result = ECarStatus::csRide;
    TStringBuf prefix = url.Before('-');
    TryFromString(prefix, result);
    return result;
}

bool NDrive::IsFree(ECarStatus status) {
    switch (status) {
    case NDrive::ECarStatus::csRide:
    case NDrive::ECarStatus::csReservation:
    case NDrive::ECarStatus::csReservationPaid:
    case NDrive::ECarStatus::csService:
    case NDrive::ECarStatus::csParking:
    case NDrive::ECarStatus::csUnknown:
    case NDrive::ECarStatus::csNew:
    case NDrive::ECarStatus::csFueling:
    case NDrive::ECarStatus::csAcceptance:
        return false;
    case NDrive::ECarStatus::csPost:
    case NDrive::ECarStatus::csFree:
        return true;
    }
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::ECarStatus& object) {
    return NJson::ToJson(NJson::Stringify(object));
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDrive::ECarStatus& result) {
    return NJson::TryFromJson(value, NJson::Stringify(result));
}
