#pragma once

#include <util/generic/strbuf.h>

namespace NDrive {
    enum class ECarStatus {
        csRide /* "ride" */,
        csFree /* "available" */,
        csReservation /* "reservation" */,
        csReservationPaid /* "reservation_paid" */,
        csService /* "service" */,
        csParking /* "parking" */,
        csUnknown /* "unknown" */,
        csNew /* "new" */,
        csFueling /* "fueling" */,
        csAcceptance /* "acceptance" */,
        csPost /* "post" */,
    };

    ECarStatus GetStatus(TStringBuf url);
    bool IsFree(ECarStatus status);
}
