#pragma once

#include <rtline/util/types/expected.h>

#include <util/generic/string.h>

namespace NDrive {
    struct TCompressionOptions {
        enum class EType {
            ZLib,
            GZip,
        };

        size_t CompressionThreshold = 512;
        EType Type = EType::ZLib;
    };

    TExpected<TString> Compress(TStringBuf data, const TCompressionOptions& options = {});
    TExpected<TString> Decompress(TStringBuf data);
}
