#include "simple.h"

#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/testing/unittest/registar.h>

namespace {
    TVector<TString> Strings = {
        "forty_two",
        "failure",
        "wow_fella",
        "adfgadfwe f029r 023mrwwem rjw efiqr jfom wjf",
        "12312i091u@*U(*212y3h89H! *(h19hgeh91 92hH!* (H(!H 991h39",
        "12hHHHHOIHOOIHOIHIOHOIHOJ)_(_)_*)(_)(+)(_)IU_(U()HIONLNMLKLMLKMKLNLBJKJBVIYGYHOPOIPOOIHOUOBHBVUYUVIBI IBONONIJOUO BIOIU",
    };
}

Y_UNIT_TEST_SUITE(SimpleCompression) {
    Y_UNIT_TEST(Plain) {
        for (auto&& data : Strings) {
            auto coded = Base64Encode(data);
            auto decompressed = NDrive::Decompress(coded);
            UNIT_ASSERT_C(decompressed, decompressed.GetError().AsStrBuf());
            UNIT_ASSERT_VALUES_EQUAL(*decompressed, data);
        }
    }

    Y_UNIT_TEST(ZLib) {
        auto options = NDrive::TCompressionOptions();
        options.CompressionThreshold = 0;

        for (auto&& data : Strings) {
            auto compressed = NDrive::Compress(data, options);
            UNIT_ASSERT(compressed);
            auto decompressed = NDrive::Decompress(*compressed);
            UNIT_ASSERT(decompressed);
            UNIT_ASSERT_VALUES_EQUAL(*decompressed, data);
        }
    }

    Y_UNIT_TEST(Size) {
        NDrive::TCompressionOptions options;
        TString data = "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";
        auto decompressed = *NDrive::Decompress(data);
        auto defaultCompression = *NDrive::Compress(decompressed, options);
        Cerr << "original: " << data.size() << Endl;
        Cerr << "default: " << defaultCompression.size() << Endl;
        auto decompressedAgain = NDrive::Decompress(defaultCompression);
        UNIT_ASSERT(decompressedAgain);
        UNIT_ASSERT_VALUES_EQUAL(decompressed, *decompressedAgain);
    }
}
