#pragma once

#include "config.h"
#include <util/string/vector.h>
#include <util/string/cast.h>
#include <util/string/subst.h>
#include <util/datetime/parser.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <rtline/library/json/parse.h>

class TCovidPassClient {
public:
    class TPassData {
        R_FIELD(TString, PassToken);
        R_FIELD(TString, CarId);
        R_FIELD(bool, IsValid, false);
        R_FIELD(TInstant, ValidUntil, TInstant::Zero());
        R_FIELD(NJson::TJsonValue, ApiResponse, NJson::JSON_NULL);
        R_FIELD(TString, Error);
    };

public:
    virtual ~TCovidPassClient() {
    }

    virtual NThreading::TFuture<TPassData> GetPassData(const TString& pass, const TInstant minUntil) const = 0;

protected:
    THolder<NNeh::THttpClient> Agent;
    mutable TString Token;
    mutable TInstant TokenValidUntil = TInstant::Zero();
};

class TCovidPassMoscowClient : public TCovidPassClient {
public:
    TCovidPassMoscowClient(const TCovidPassMoscowConfig& config)
        : Config(config)
    {
        Agent = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }

    virtual NThreading::TFuture<TCovidPassClient::TPassData> GetPassData(const TString& pass, const TInstant minUntil) const override;

private:
    TCovidPassMoscowConfig Config;
    bool CheckAndUpdateToken(TString& error) const;
};

class TCovidPassMoscowRegionClient : public TCovidPassClient {
public:
    TCovidPassMoscowRegionClient(const TCovidPassMoscowRegionConfig& config)
        : Config(config)
    {
        Agent = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }

    virtual NThreading::TFuture<TCovidPassClient::TPassData> GetPassData(const TString& pass, const TInstant minUntil) const override;

private:
    TCovidPassMoscowRegionConfig Config;
    bool CheckAndUpdateToken(TString& error) const;
    bool UpdateToken(const NJson::TJsonValue& payload, const TString& uri, TString& error) const;
    mutable TString RefreshToken;
};

class TCovidPassGosuslugiClient : public TCovidPassClient {
public:
    TCovidPassGosuslugiClient(const TCovidPassGosuslugiConfig& config)
        : Config(config)
    {
        Agent = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }

    virtual NThreading::TFuture<TCovidPassClient::TPassData> GetPassData(const TString& pass, const TInstant minUntil) const override;

private:
    TCovidPassGosuslugiConfig Config;
};

void ParseJsonReply(const NJson::TJsonValue& replyJson, const TInstant minUntil, TCovidPassClient::TPassData& passDataResult);
TString TokenizeString(size_t from, size_t to, size_t skip, TChar token, const TString& str);
