#include "config.h"

void TCovidPassClientConfig::Init(const TYandexConfig::Section* section) {
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    {
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }
}

void TCovidPassClientConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "ApiPath: " << ApiPath << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

void TCovidPassMoscowConfig::Init(const TYandexConfig::Section* section) {
    SetProtectedUri(section->GetDirectives().Value<TString>("Uri", "https://api.mos.ru:8243"));
    SetProtectedApiPath(section->GetDirectives().Value<TString>("ApiPath", "taxi/1.0/getInfo"));
    Key = section->GetDirectives().Value<TString>("Key", Key);
    Secret = section->GetDirectives().Value<TString>("Secret", Secret);
    TCovidPassClientConfig::Init(section);
}

void TCovidPassMoscowConfig::ToString(IOutputStream& os) const {
    os << "Key: " << Key << Endl;
    os << "Secret: " << Secret << Endl;
    TCovidPassClientConfig::ToString(os);
}

void TCovidPassMoscowRegionConfig::Init(const TYandexConfig::Section* section) {
    SetProtectedUri(section->GetDirectives().Value<TString>("Uri", "https://uslugi.mosreg.ru"));
    SetProtectedApiPath(section->GetDirectives().Value<TString>("ApiPath", "api/v2/token/permits?code="));
    Login = section->GetDirectives().Value<TString>("Login", Login);
    Password = section->GetDirectives().Value<TString>("Password", Password);
    TCovidPassClientConfig::Init(section);
}

void TCovidPassMoscowRegionConfig::ToString(IOutputStream& os) const {
    os << "Login: " << Login << Endl;
    os << "Password: " << Password << Endl;
    TCovidPassClientConfig::ToString(os);
}


void TCovidPassGosuslugiConfig::Init(const TYandexConfig::Section* section) {
    SetProtectedUri(section->GetDirectives().Value<TString>("Uri", "https://www.gosuslugi.ru"));
    SetProtectedApiPath(section->GetDirectives().Value<TString>("ApiPath", "api/qr/v2/getMos/"));
    TCovidPassClientConfig::Init(section);
}

TCovidPassMoscowRegionConfig TCovidPassMoscowRegionConfig::ParseFromString(const TString& configStr) {
    TCovidPassMoscowRegionConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}

TCovidPassMoscowConfig TCovidPassMoscowConfig::ParseFromString(const TString& configStr) {
    TCovidPassMoscowConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}

TCovidPassGosuslugiConfig TCovidPassGosuslugiConfig::ParseFromString(const TString& configStr) {
    TCovidPassGosuslugiConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
