#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/mediator/global_notifications/system_status.h>
#include <library/cpp/string_utils/url/url.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>
#include <rtline/util/types/accessor.h>

#include <util/stream/file.h>

class TCovidPassClientConfig {
    R_READONLY(TString, Uri);
    R_READONLY(TString, ApiPath);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(20));
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);

public:
    virtual void Init(const TYandexConfig::Section* section) = 0;
    virtual void ToString(IOutputStream& os) const;
    virtual ~TCovidPassClientConfig() {
    }
};

class TCovidPassMoscowConfig : public TCovidPassClientConfig {
public:
    R_READONLY(TString, Key);
    R_READONLY(TString, Secret);

public:
    void Init(const TYandexConfig::Section* section) override;
    void ToString(IOutputStream& os) const override;

    static TCovidPassMoscowConfig ParseFromString(const TString& configStr);
};

class TCovidPassMoscowRegionConfig : public TCovidPassClientConfig {
public:
    R_READONLY(TString, Login);
    R_READONLY(TString, Password);

public:
    void Init(const TYandexConfig::Section* section) override;
    void ToString(IOutputStream& os) const override;

    static TCovidPassMoscowRegionConfig ParseFromString(const TString& configStr);
};

class TCovidPassGosuslugiConfig : public TCovidPassClientConfig {
public:
    void Init(const TYandexConfig::Section* section) override;

    static TCovidPassGosuslugiConfig ParseFromString(const TString& configStr);
};
