#include "client.h"

#include <rtline/library/json/parse.h>
#include <rtline/library/unistat/cache.h>

#include <library/cpp/json/json_reader.h>


namespace NDrive {

    TDadataClient::TDadataClient(const TDadataConfig& config)
        : Config(config)
        , Client(MakeAtomicShared<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig()))
    {
    }

    const TDadataConfig& TDadataClient::GetConfig() const {
        return Config;
    }

    NThreading::TFuture<TVector<TDadataAddresses>> TDadataClient::CleanAddress(const TVector<TString>& context) const {
        NNeh::THttpRequest request;
        request.SetUri(Config.GetUriPath());
        request.SetContentType("application/json");
        {
            NJson::TJsonValue payload = NJson::JSON_ARRAY;
            for (auto&& item : context) {
                payload.AppendValue(item);
            }
            request.SetPostData(payload);
        }
        Config.Authorize(request);
        return Client->SendAsync(request, Now() + Config.GetRequestTimeout()).Apply([](const NThreading::TFuture<NUtil::THttpReply>& r) {
            const auto& report = r.GetValue();
            TUnistatSignalsCache::SignalAdd("dadata-clean-addres-codes", ToString(report.Code()), 1);
            NJson::TJsonValue rawResult;
            if (!NJson::ReadJsonFastTree(report.EnsureSuccessfulReply().Content(), &rawResult)) {
                ythrow yexception() << "Error getting objects: " << report.GetDebugReply();
            }
            TVector<TDadataAddresses> result;
            if (!NJson::ParseField(rawResult, result, /* required = */ true)) {
                ythrow yexception() << "Fail to parse reply: " << rawResult.GetStringRobust();
            }
            return result;
        });
    }
}
