#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

namespace NDrive {

    class TDadataConfig {
    public:
        bool Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        void Authorize(NNeh::THttpRequest& request) const;
        static TAtomicSharedPtr<TDadataConfig> ParseFromString(const TString& configStr);

    private:
        R_READONLY(TString, Uri, "https://cleaner.dadata.ru");
        R_READONLY(TString, UriPath, "api/v1/clean/address");
        R_READONLY(TString, Token);
        R_READONLY(TString, TokenPath);
        R_READONLY(TString, Secret);
        R_READONLY(TString, SecretPath);
        R_READONLY(NSimpleMeta::TConfig, RequestConfig);
        R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
    };

}
