#include "entities.h"

#include <rtline/library/json/parse.h>


template <>
bool NJson::TryFromJson(const NJson::TJsonValue& json, NDrive::TDadataAddresses& result) {
    return
           NJson::ParseField(json, "country", result.MutableCountry())
        && NJson::ParseField(json, "region", result.MutableRegion())
        && NJson::ParseField(json, "region_with_type", result.MutableRegionWithType())
        && NJson::ParseField(json, "city", result.MutableCity())
        && NJson::ParseField(json, "street", result.MutableStreet())
        && NJson::ParseField(json, "house", result.MutableHouse())
        && NJson::ParseField(json, "postal_code", result.MutablePostCode())
        && NJson::ParseField(json, "kladr_id", result.MutableKladrId())
        && NJson::ParseField(json, "region_kladr_id", result.MutableRegoinKladrId())
        && NJson::ParseField(json, "fias_id", result.MutableFiasId())
        && NJson::ParseField(json, "street_fias_id", result.MutableStreetFiasId())
        && NJson::ParseField(json, "settlement_fias_id", result.MutableSettlementFiasId())
        && NJson::ParseField(json, "region_fias_id", result.MutableRegionFiasId())
    ;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::TDadataAddresses& object) {
    NJson::TJsonValue json;
    NJson::InsertField(json, "country", object.OptionalCountry());
    NJson::InsertField(json, "region", object.OptionalRegion());
    NJson::InsertField(json, "region_with_type", object.OptionalRegionWithType());
    NJson::InsertField(json, "city", object.OptionalCity());
    NJson::InsertField(json, "street", object.OptionalStreet());
    NJson::InsertField(json, "house", object.OptionalHouse());
    NJson::InsertField(json, "postal_code", object.OptionalPostCode());
    NJson::InsertField(json, "kladr_id", object.OptionalKladrId());
    NJson::InsertField(json, "region_kladr_id", object.OptionalRegoinKladrId());
    NJson::InsertField(json, "fias_id", object.OptionalFiasId());
    NJson::InsertField(json, "street_fias_id", object.OptionalStreetFiasId());
    NJson::InsertField(json, "settlement_fias_id", object.OptionalSettlementFiasId());
    NJson::InsertField(json, "region_fias_id", object.OptionalRegionFiasId());
    return json;
}
